<?php

namespace App\Models\Involvements;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EpisodeType extends Model 
{

    protected $table = 'episode_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getEventFacts()
    {
        return $this->hasMany('App\Models\Events\EventFacts');
    }

    public function getChallenges()
    {
        return $this->hasMany('App\Models\Challenges\Challenge');
    }

    public function getQuizes()
    {
        return $this->hasMany('App\Models\Quizes\Quiz');
    }

    public function getActivities()
    {
        return $this->hasMany('App\Models\Activities\Activity');
    }

    public function getInvolvements()
    {
        return $this->belongsToMany('App\Models\Involvements\Involvement', 'episode_type_involvement');
    }

}